/***************************************************************************/
/*                                                                         */
/* Copyright (c) 1995 SiS Corp. Setup Utility                              */
/*                                                                         */
/***************************************************************************/

Trace 'O'
Address CMD
'@ECHO ON'

/**************/
/* Initialize */
/**************/
Call rxfuncadd sysloadfuncs, rexxutil, sysloadfuncs
Call sysloadfuncs

toolpath = ''
bootdrive = Substr(Translate(Value('PATH',,'OS2ENVIRONMENT')),Pos('\OS2\SYSTEM',Translate(Value('PATH',,'OS2ENVIRONMENT')))-2,2)
tooldrive = bootdrive
toolpath=tooldrive||"\SISDRV"

"md" ""||bootdrive||"\sisdrv  "

Say ""
Say " Copy Files ...........Please Wait"

'@ECHO OFF'
"copy" "*.* "||toolpath||"\*.* > NUL "


If tooldrive <> '' Then Do
  Call SysCreateObject 'WPProgram', 'SiS Install','<WP_DESKTOP>','OBJECTID=<TK_SISDRV>;EXENAME='||toolpath||'\sisinst.cmd;PROGTYPE=PM;ICONFILE='||toolpath||'\sis.ico','R'
End
/*****************************************************************************/
/*        Update the CONFIG.SYS                                              */
/*****************************************************************************/
  Call Tk21ChgConfig


/****************/
/* Exit program */
/****************/
Endit:
Exit 0

/***************************/
/* Change the CONFIG.SYS   */
/***************************/

Tk21ChgConfig:   /* change the config.sys file for Toolkit 2.1 */

'@cls'

oldconfig=bootdrive'\CONFIG.SYS'
newconfig=bootdrive'\CONFIG.BK$'

os2vsvga='DEVICE='bootdrive'\OS2\MDOS\VVGA.SYS'

/*
 * read the file one line at a time, and write it all out, making
 * changes accordingly - need to change path, libpath, help, bookshelf
 * ipfc, include, lib
 */

'@del 'newconfig ' 2>nul >nul'

Do while lines(oldconfig)
    inline=linein(oldconfig)

    /******************************************/
    /* parse the line into variable and value */
    /******************************************/

    parse value inline with os2var ' ' os2value

    /********************************************************/
    /* translate the variable into uppercase for comparison */
    /********************************************************/

    os2var=translate(os2var)
    Select

        /********************************************************/
        /*          For Add VSVGA                               */
        /********************************************************/

        when os2var=os2vsvga Then Do
            sisline='DEVICE='bootdrive'\OS2\MDOS\VSVGA.SYS'

            /*
             * write the line out to the new config file
             */

             result=lineout(newconfig, sisline)
             If result=1 Then Do
                 writeerror()
                 return 1
             End

        End

        otherwise Do
            /*
             * write the line out to the new config file
             */

            result=lineout(newconfig, inline)
            If result=1 Then Do
                writeerror()
                return 1
            End
        End

    End /* Select */

End /* Do */

/*********************/
/* close the files   */
/*********************/

result=lineout(newconfig)
result=lineout(oldconfig)

/******************************************************************/
/* Copy created file(CONFIG.BK$) to original file(CONFIG.SYS)     */
/******************************************************************/
'@copy 'newconfig' 'oldconfig' 2>nul >nul'
'@del 'newconfig' 2>nul >nul'

/******************************************************************/
/*  Finished the Update                                           */
/******************************************************************/

'@cls'
Say ' '
Say '   Now Create A "SiS Install" Icon on Your Desktop'
Say '   Please Shutdown and reboot. When System restart,'
Say '   double click the "SiS Install" Icon to do futher'
Say '   installation.'
Say ' '

return 0


writeerror:         /* display a write error to the screen */
'@cls'
Say ' '
Say ' '
Say '                       *****  ERROR  *****'
Say ' '
Say '               An error occured while attempting to write the '
Say '               'bootdrive'\CONFIG.SYS file.  Check the available disk'
Say '               disk space on the current drive and retry the'
Say '               install process.'
Say ' '
return 0

